package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.resourcegroups.model.primitives.NextToken
import scala.jdk.CollectionConverters.*
final case class SearchResourcesResponse(
    resourceIdentifiers: Optional[
      Iterable[zio.aws.resourcegroups.model.ResourceIdentifier]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    queryErrors: Optional[Iterable[zio.aws.resourcegroups.model.QueryError]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.SearchResourcesResponse = {
    import SearchResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.SearchResourcesResponse
      .builder()
      .optionallyWith(
        resourceIdentifiers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceIdentifiers)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        queryErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.queryErrors)
      .build()
  }
  def asReadOnly
      : zio.aws.resourcegroups.model.SearchResourcesResponse.ReadOnly =
    zio.aws.resourcegroups.model.SearchResourcesResponse.wrap(buildAwsValue())
}
object SearchResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.SearchResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.SearchResourcesResponse =
      zio.aws.resourcegroups.model.SearchResourcesResponse(
        resourceIdentifiers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        queryErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resourceIdentifiers: Optional[
      List[zio.aws.resourcegroups.model.ResourceIdentifier.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def queryErrors
        : Optional[List[zio.aws.resourcegroups.model.QueryError.ReadOnly]]
    def getResourceIdentifiers: ZIO[Any, AwsError, List[
      zio.aws.resourcegroups.model.ResourceIdentifier.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceIdentifiers", resourceIdentifiers)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getQueryErrors: ZIO[Any, AwsError, List[
      zio.aws.resourcegroups.model.QueryError.ReadOnly
    ]] = AwsError.unwrapOptionField("queryErrors", queryErrors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.SearchResourcesResponse
  ) extends zio.aws.resourcegroups.model.SearchResourcesResponse.ReadOnly {
    override val resourceIdentifiers: Optional[
      List[zio.aws.resourcegroups.model.ResourceIdentifier.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceIdentifiers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.resourcegroups.model.ResourceIdentifier.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.resourcegroups.model.primitives.NextToken(value))
    override val queryErrors
        : Optional[List[zio.aws.resourcegroups.model.QueryError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.queryErrors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.resourcegroups.model.QueryError.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.SearchResourcesResponse
  ): zio.aws.resourcegroups.model.SearchResourcesResponse.ReadOnly =
    new Wrapper(impl)
}
