package zio.aws.resourcegroups.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceStatusValue {
  def unwrap
      : software.amazon.awssdk.services.resourcegroups.model.ResourceStatusValue
}
object ResourceStatusValue {
  def wrap(
      value: software.amazon.awssdk.services.resourcegroups.model.ResourceStatusValue
  ): zio.aws.resourcegroups.model.ResourceStatusValue = value match {
    case software.amazon.awssdk.services.resourcegroups.model.ResourceStatusValue.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.resourcegroups.model.ResourceStatusValue.PENDING =>
      val r = PENDING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.resourcegroups.model.ResourceStatusValue {
    override def unwrap
        : software.amazon.awssdk.services.resourcegroups.model.ResourceStatusValue =
      software.amazon.awssdk.services.resourcegroups.model.ResourceStatusValue.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.resourcegroups.model.ResourceStatusValue {
    override def unwrap
        : software.amazon.awssdk.services.resourcegroups.model.ResourceStatusValue =
      software.amazon.awssdk.services.resourcegroups.model.ResourceStatusValue.PENDING
  }
}
