package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateAccountSettingsResponse(
    accountSettings: Optional[zio.aws.resourcegroups.model.AccountSettings] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.UpdateAccountSettingsResponse = {
    import UpdateAccountSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.UpdateAccountSettingsResponse
      .builder()
      .optionallyWith(accountSettings.map(value => value.buildAwsValue()))(
        _.accountSettings
      )
      .build()
  }
  def asReadOnly
      : zio.aws.resourcegroups.model.UpdateAccountSettingsResponse.ReadOnly =
    zio.aws.resourcegroups.model.UpdateAccountSettingsResponse
      .wrap(buildAwsValue())
}
object UpdateAccountSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.UpdateAccountSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.UpdateAccountSettingsResponse =
      zio.aws.resourcegroups.model.UpdateAccountSettingsResponse(
        accountSettings.map(value => value.asEditable)
      )
    def accountSettings
        : Optional[zio.aws.resourcegroups.model.AccountSettings.ReadOnly]
    def getAccountSettings: ZIO[
      Any,
      AwsError,
      zio.aws.resourcegroups.model.AccountSettings.ReadOnly
    ] = AwsError.unwrapOptionField("accountSettings", accountSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.UpdateAccountSettingsResponse
  ) extends zio.aws.resourcegroups.model.UpdateAccountSettingsResponse.ReadOnly {
    override val accountSettings
        : Optional[zio.aws.resourcegroups.model.AccountSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountSettings())
        .map(value => zio.aws.resourcegroups.model.AccountSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.UpdateAccountSettingsResponse
  ): zio.aws.resourcegroups.model.UpdateAccountSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
