package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetAccountSettingsResponse(
    accountSettings: Optional[zio.aws.resourcegroups.model.AccountSettings] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.GetAccountSettingsResponse = {
    import GetAccountSettingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.GetAccountSettingsResponse
      .builder()
      .optionallyWith(accountSettings.map(value => value.buildAwsValue()))(
        _.accountSettings
      )
      .build()
  }
  def asReadOnly
      : zio.aws.resourcegroups.model.GetAccountSettingsResponse.ReadOnly =
    zio.aws.resourcegroups.model.GetAccountSettingsResponse
      .wrap(buildAwsValue())
}
object GetAccountSettingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.GetAccountSettingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.GetAccountSettingsResponse =
      zio.aws.resourcegroups.model.GetAccountSettingsResponse(
        accountSettings.map(value => value.asEditable)
      )
    def accountSettings
        : Optional[zio.aws.resourcegroups.model.AccountSettings.ReadOnly]
    def getAccountSettings: ZIO[
      Any,
      AwsError,
      zio.aws.resourcegroups.model.AccountSettings.ReadOnly
    ] = AwsError.unwrapOptionField("accountSettings", accountSettings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.GetAccountSettingsResponse
  ) extends zio.aws.resourcegroups.model.GetAccountSettingsResponse.ReadOnly {
    override val accountSettings
        : Optional[zio.aws.resourcegroups.model.AccountSettings.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.accountSettings())
        .map(value => zio.aws.resourcegroups.model.AccountSettings.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.GetAccountSettingsResponse
  ): zio.aws.resourcegroups.model.GetAccountSettingsResponse.ReadOnly =
    new Wrapper(impl)
}
