package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.resourcegroups.model.primitives.GroupLifecycleEventsStatusMessage
import scala.jdk.CollectionConverters.*
final case class AccountSettings(
    groupLifecycleEventsDesiredStatus: Optional[
      zio.aws.resourcegroups.model.GroupLifecycleEventsDesiredStatus
    ] = Optional.Absent,
    groupLifecycleEventsStatus: Optional[
      zio.aws.resourcegroups.model.GroupLifecycleEventsStatus
    ] = Optional.Absent,
    groupLifecycleEventsStatusMessage: Optional[
      GroupLifecycleEventsStatusMessage
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.AccountSettings = {
    import AccountSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.AccountSettings
      .builder()
      .optionallyWith(
        groupLifecycleEventsDesiredStatus.map(value => value.unwrap)
      )(_.groupLifecycleEventsDesiredStatus)
      .optionallyWith(groupLifecycleEventsStatus.map(value => value.unwrap))(
        _.groupLifecycleEventsStatus
      )
      .optionallyWith(
        groupLifecycleEventsStatusMessage.map(value =>
          GroupLifecycleEventsStatusMessage.unwrap(value): java.lang.String
        )
      )(_.groupLifecycleEventsStatusMessage)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.AccountSettings.ReadOnly =
    zio.aws.resourcegroups.model.AccountSettings.wrap(buildAwsValue())
}
object AccountSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.AccountSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.AccountSettings =
      zio.aws.resourcegroups.model.AccountSettings(
        groupLifecycleEventsDesiredStatus.map(value => value),
        groupLifecycleEventsStatus.map(value => value),
        groupLifecycleEventsStatusMessage.map(value => value)
      )
    def groupLifecycleEventsDesiredStatus: Optional[
      zio.aws.resourcegroups.model.GroupLifecycleEventsDesiredStatus
    ]
    def groupLifecycleEventsStatus
        : Optional[zio.aws.resourcegroups.model.GroupLifecycleEventsStatus]
    def groupLifecycleEventsStatusMessage
        : Optional[GroupLifecycleEventsStatusMessage]
    def getGroupLifecycleEventsDesiredStatus: ZIO[
      Any,
      AwsError,
      zio.aws.resourcegroups.model.GroupLifecycleEventsDesiredStatus
    ] = AwsError.unwrapOptionField(
      "groupLifecycleEventsDesiredStatus",
      groupLifecycleEventsDesiredStatus
    )
    def getGroupLifecycleEventsStatus: ZIO[
      Any,
      AwsError,
      zio.aws.resourcegroups.model.GroupLifecycleEventsStatus
    ] = AwsError.unwrapOptionField(
      "groupLifecycleEventsStatus",
      groupLifecycleEventsStatus
    )
    def getGroupLifecycleEventsStatusMessage
        : ZIO[Any, AwsError, GroupLifecycleEventsStatusMessage] =
      AwsError.unwrapOptionField(
        "groupLifecycleEventsStatusMessage",
        groupLifecycleEventsStatusMessage
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.AccountSettings
  ) extends zio.aws.resourcegroups.model.AccountSettings.ReadOnly {
    override val groupLifecycleEventsDesiredStatus: Optional[
      zio.aws.resourcegroups.model.GroupLifecycleEventsDesiredStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.groupLifecycleEventsDesiredStatus())
      .map(value =>
        zio.aws.resourcegroups.model.GroupLifecycleEventsDesiredStatus
          .wrap(value)
      )
    override val groupLifecycleEventsStatus
        : Optional[zio.aws.resourcegroups.model.GroupLifecycleEventsStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupLifecycleEventsStatus())
        .map(value =>
          zio.aws.resourcegroups.model.GroupLifecycleEventsStatus.wrap(value)
        )
    override val groupLifecycleEventsStatusMessage
        : Optional[GroupLifecycleEventsStatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.groupLifecycleEventsStatusMessage())
      .map(value =>
        zio.aws.resourcegroups.model.primitives
          .GroupLifecycleEventsStatusMessage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.AccountSettings
  ): zio.aws.resourcegroups.model.AccountSettings.ReadOnly = new Wrapper(impl)
}
