package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.resourcegroups.model.primitives.GroupName
import scala.jdk.CollectionConverters.*
final case class GroupQuery(
    groupName: GroupName,
    resourceQuery: zio.aws.resourcegroups.model.ResourceQuery
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.GroupQuery = {
    import GroupQuery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.GroupQuery
      .builder()
      .groupName(GroupName.unwrap(groupName): java.lang.String)
      .resourceQuery(resourceQuery.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.GroupQuery.ReadOnly =
    zio.aws.resourcegroups.model.GroupQuery.wrap(buildAwsValue())
}
object GroupQuery {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.GroupQuery
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.GroupQuery =
      zio.aws.resourcegroups.model
        .GroupQuery(groupName, resourceQuery.asEditable)
    def groupName: GroupName
    def resourceQuery: zio.aws.resourcegroups.model.ResourceQuery.ReadOnly
    def getGroupName: ZIO[Any, Nothing, GroupName] = ZIO.succeed(groupName)
    def getResourceQuery: ZIO[
      Any,
      Nothing,
      zio.aws.resourcegroups.model.ResourceQuery.ReadOnly
    ] = ZIO.succeed(resourceQuery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.GroupQuery
  ) extends zio.aws.resourcegroups.model.GroupQuery.ReadOnly {
    override val groupName: GroupName =
      zio.aws.resourcegroups.model.primitives.GroupName(impl.groupName())
    override val resourceQuery
        : zio.aws.resourcegroups.model.ResourceQuery.ReadOnly =
      zio.aws.resourcegroups.model.ResourceQuery.wrap(impl.resourceQuery())
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.GroupQuery
  ): zio.aws.resourcegroups.model.GroupQuery.ReadOnly = new Wrapper(impl)
}
