package zio.aws.resourcegroups.model
import scala.jdk.CollectionConverters.*
sealed trait GroupFilterName {
  def unwrap
      : software.amazon.awssdk.services.resourcegroups.model.GroupFilterName
}
object GroupFilterName {
  def wrap(
      value: software.amazon.awssdk.services.resourcegroups.model.GroupFilterName
  ): zio.aws.resourcegroups.model.GroupFilterName = value match {
    case software.amazon.awssdk.services.resourcegroups.model.GroupFilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.resourcegroups.model.GroupFilterName.RESOURCE_TYPE =>
      val r = `resource-type`
      r
    case software.amazon.awssdk.services.resourcegroups.model.GroupFilterName.CONFIGURATION_TYPE =>
      val r = `configuration-type`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.resourcegroups.model.GroupFilterName {
    override def unwrap
        : software.amazon.awssdk.services.resourcegroups.model.GroupFilterName =
      software.amazon.awssdk.services.resourcegroups.model.GroupFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object `resource-type`
      extends zio.aws.resourcegroups.model.GroupFilterName {
    override def unwrap
        : software.amazon.awssdk.services.resourcegroups.model.GroupFilterName =
      software.amazon.awssdk.services.resourcegroups.model.GroupFilterName.RESOURCE_TYPE
  }
  case object `configuration-type`
      extends zio.aws.resourcegroups.model.GroupFilterName {
    override def unwrap
        : software.amazon.awssdk.services.resourcegroups.model.GroupFilterName =
      software.amazon.awssdk.services.resourcegroups.model.GroupFilterName.CONFIGURATION_TYPE
  }
}
