package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.resourcegroups.model.primitives.ResourceArn
import scala.jdk.CollectionConverters.*
final case class PendingResource(
    resourceArn: Optional[ResourceArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.PendingResource = {
    import PendingResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.PendingResource
      .builder()
      .optionallyWith(
        resourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.PendingResource.ReadOnly =
    zio.aws.resourcegroups.model.PendingResource.wrap(buildAwsValue())
}
object PendingResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.PendingResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.PendingResource =
      zio.aws.resourcegroups.model
        .PendingResource(resourceArn.map(value => value))
    def resourceArn: Optional[ResourceArn]
    def getResourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.PendingResource
  ) extends zio.aws.resourcegroups.model.PendingResource.ReadOnly {
    override val resourceArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.resourcegroups.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.PendingResource
  ): zio.aws.resourcegroups.model.PendingResource.ReadOnly = new Wrapper(impl)
}
