package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.resourcegroups.model.primitives.{
  GroupConfigurationParameterValue,
  GroupConfigurationParameterName
}
import scala.jdk.CollectionConverters.*
final case class GroupConfigurationParameter(
    name: GroupConfigurationParameterName,
    values: Optional[Iterable[GroupConfigurationParameterValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationParameter = {
    import GroupConfigurationParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationParameter
      .builder()
      .name(GroupConfigurationParameterName.unwrap(name): java.lang.String)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            GroupConfigurationParameterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly
      : zio.aws.resourcegroups.model.GroupConfigurationParameter.ReadOnly =
    zio.aws.resourcegroups.model.GroupConfigurationParameter
      .wrap(buildAwsValue())
}
object GroupConfigurationParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.GroupConfigurationParameter =
      zio.aws.resourcegroups.model
        .GroupConfigurationParameter(name, values.map(value => value))
    def name: GroupConfigurationParameterName
    def values: Optional[List[GroupConfigurationParameterValue]]
    def getName: ZIO[Any, Nothing, GroupConfigurationParameterName] =
      ZIO.succeed(name)
    def getValues: ZIO[Any, AwsError, List[GroupConfigurationParameterValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationParameter
  ) extends zio.aws.resourcegroups.model.GroupConfigurationParameter.ReadOnly {
    override val name: GroupConfigurationParameterName =
      zio.aws.resourcegroups.model.primitives
        .GroupConfigurationParameterName(impl.name())
    override val values: Optional[List[GroupConfigurationParameterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.values())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.resourcegroups.model.primitives
              .GroupConfigurationParameterValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationParameter
  ): zio.aws.resourcegroups.model.GroupConfigurationParameter.ReadOnly =
    new Wrapper(impl)
}
