package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.resourcegroups.model.primitives.{TagKey, GroupArn}
import scala.jdk.CollectionConverters.*
final case class UntagRequest(arn: GroupArn, keys: Iterable[TagKey]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.UntagRequest = {
    import UntagRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.UntagRequest
      .builder()
      .arn(GroupArn.unwrap(arn): java.lang.String)
      .keys(keys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.UntagRequest.ReadOnly =
    zio.aws.resourcegroups.model.UntagRequest.wrap(buildAwsValue())
}
object UntagRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.UntagRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.UntagRequest =
      zio.aws.resourcegroups.model.UntagRequest(arn, keys)
    def arn: GroupArn
    def keys: List[TagKey]
    def getArn: ZIO[Any, Nothing, GroupArn] = ZIO.succeed(arn)
    def getKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(keys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.UntagRequest
  ) extends zio.aws.resourcegroups.model.UntagRequest.ReadOnly {
    override val arn: GroupArn =
      zio.aws.resourcegroups.model.primitives.GroupArn(impl.arn())
    override val keys: List[TagKey] = impl
      .keys()
      .asScala
      .map { item =>
        zio.aws.resourcegroups.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.UntagRequest
  ): zio.aws.resourcegroups.model.UntagRequest.ReadOnly = new Wrapper(impl)
}
