package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.resourcegroups.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters.*
final case class CreateGroupResponse(
    group: Optional[zio.aws.resourcegroups.model.Group] = Optional.Absent,
    resourceQuery: Optional[zio.aws.resourcegroups.model.ResourceQuery] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    groupConfiguration: Optional[
      zio.aws.resourcegroups.model.GroupConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.CreateGroupResponse = {
    import CreateGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.CreateGroupResponse
      .builder()
      .optionallyWith(group.map(value => value.buildAwsValue()))(_.group)
      .optionallyWith(resourceQuery.map(value => value.buildAwsValue()))(
        _.resourceQuery
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(groupConfiguration.map(value => value.buildAwsValue()))(
        _.groupConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.CreateGroupResponse.ReadOnly =
    zio.aws.resourcegroups.model.CreateGroupResponse.wrap(buildAwsValue())
}
object CreateGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.CreateGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.CreateGroupResponse =
      zio.aws.resourcegroups.model.CreateGroupResponse(
        group.map(value => value.asEditable),
        resourceQuery.map(value => value.asEditable),
        tags.map(value => value),
        groupConfiguration.map(value => value.asEditable)
      )
    def group: Optional[zio.aws.resourcegroups.model.Group.ReadOnly]
    def resourceQuery
        : Optional[zio.aws.resourcegroups.model.ResourceQuery.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def groupConfiguration
        : Optional[zio.aws.resourcegroups.model.GroupConfiguration.ReadOnly]
    def getGroup
        : ZIO[Any, AwsError, zio.aws.resourcegroups.model.Group.ReadOnly] =
      AwsError.unwrapOptionField("group", group)
    def getResourceQuery: ZIO[
      Any,
      AwsError,
      zio.aws.resourcegroups.model.ResourceQuery.ReadOnly
    ] = AwsError.unwrapOptionField("resourceQuery", resourceQuery)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getGroupConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.resourcegroups.model.GroupConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("groupConfiguration", groupConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.CreateGroupResponse
  ) extends zio.aws.resourcegroups.model.CreateGroupResponse.ReadOnly {
    override val group: Optional[zio.aws.resourcegroups.model.Group.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.group())
        .map(value => zio.aws.resourcegroups.model.Group.wrap(value))
    override val resourceQuery
        : Optional[zio.aws.resourcegroups.model.ResourceQuery.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceQuery())
        .map(value => zio.aws.resourcegroups.model.ResourceQuery.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.resourcegroups.model.primitives.TagKey(
              key
            ) -> zio.aws.resourcegroups.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val groupConfiguration
        : Optional[zio.aws.resourcegroups.model.GroupConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupConfiguration())
        .map(value =>
          zio.aws.resourcegroups.model.GroupConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.CreateGroupResponse
  ): zio.aws.resourcegroups.model.CreateGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
