package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.resourcegroups.model.primitives.QueryErrorMessage
import scala.jdk.CollectionConverters.*
final case class QueryError(
    errorCode: Optional[zio.aws.resourcegroups.model.QueryErrorCode] =
      Optional.Absent,
    message: Optional[QueryErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.QueryError = {
    import QueryError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.QueryError
      .builder()
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(
        message.map(value => QueryErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.QueryError.ReadOnly =
    zio.aws.resourcegroups.model.QueryError.wrap(buildAwsValue())
}
object QueryError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.QueryError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.QueryError =
      zio.aws.resourcegroups.model
        .QueryError(errorCode.map(value => value), message.map(value => value))
    def errorCode: Optional[zio.aws.resourcegroups.model.QueryErrorCode]
    def message: Optional[QueryErrorMessage]
    def getErrorCode
        : ZIO[Any, AwsError, zio.aws.resourcegroups.model.QueryErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getMessage: ZIO[Any, AwsError, QueryErrorMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.QueryError
  ) extends zio.aws.resourcegroups.model.QueryError.ReadOnly {
    override val errorCode
        : Optional[zio.aws.resourcegroups.model.QueryErrorCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorCode())
        .map(value => zio.aws.resourcegroups.model.QueryErrorCode.wrap(value))
    override val message: Optional[QueryErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value =>
        zio.aws.resourcegroups.model.primitives.QueryErrorMessage(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.QueryError
  ): zio.aws.resourcegroups.model.QueryError.ReadOnly = new Wrapper(impl)
}
