package zio.aws.resourcegroups
import zio.aws.resourcegroups.model.ResourceIdentifier.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.resourcegroups.model.{
  SearchResourcesRequest,
  UpdateGroupQueryRequest,
  ListGroupResourcesRequest,
  GetGroupRequest,
  UpdateGroupRequest,
  DeleteGroupRequest,
  GetGroupQueryRequest,
  UntagRequest,
  TagRequest,
  ListGroupsRequest,
  PutGroupConfigurationRequest,
  GetGroupConfigurationRequest,
  GetTagsRequest,
  CreateGroupRequest,
  GroupResourcesRequest,
  UngroupResourcesRequest
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import software.amazon.awssdk.services.resourcegroups.{
  ResourceGroupsAsyncClientBuilder,
  ResourceGroupsAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.resourcegroups.model.{
  DeleteGroupResponse,
  GroupResourcesResponse,
  GetTagsResponse,
  TagResponse,
  PutGroupConfigurationResponse,
  GetGroupQueryResponse,
  Group,
  UngroupResourcesResponse,
  SearchResourcesResponse,
  UntagResponse,
  ResourceIdentifier,
  ListGroupsResponse,
  GetGroupConfigurationResponse,
  ListGroupResourcesResponse,
  CreateGroupResponse,
  UpdateGroupQueryResponse,
  GetGroupResponse,
  UpdateGroupResponse
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import scala.jdk.CollectionConverters.*
trait ResourceGroups extends AspectSupport[ResourceGroups] {
  val api: ResourceGroupsAsyncClient
  def getGroupQuery(
      request: GetGroupQueryRequest
  ): IO[AwsError, zio.aws.resourcegroups.model.GetGroupQueryResponse.ReadOnly]
  def untag(
      request: UntagRequest
  ): IO[AwsError, zio.aws.resourcegroups.model.UntagResponse.ReadOnly]
  def deleteGroup(
      request: DeleteGroupRequest
  ): IO[AwsError, zio.aws.resourcegroups.model.DeleteGroupResponse.ReadOnly]
  def listGroups(
      request: ListGroupsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.resourcegroups.model.ListGroupsResponse.ReadOnly,
    zio.aws.resourcegroups.model.Group.ReadOnly
  ]]
  def listGroupsPaginated(
      request: ListGroupsRequest
  ): IO[AwsError, zio.aws.resourcegroups.model.ListGroupsResponse.ReadOnly]
  def updateGroupQuery(request: UpdateGroupQueryRequest): IO[
    AwsError,
    zio.aws.resourcegroups.model.UpdateGroupQueryResponse.ReadOnly
  ]
  def searchResources(
      request: SearchResourcesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.resourcegroups.model.SearchResourcesResponse.ReadOnly,
    ReadOnly
  ]]
  def searchResourcesPaginated(
      request: SearchResourcesRequest
  ): IO[AwsError, zio.aws.resourcegroups.model.SearchResourcesResponse.ReadOnly]
  def createGroup(
      request: CreateGroupRequest
  ): IO[AwsError, zio.aws.resourcegroups.model.CreateGroupResponse.ReadOnly]
  def tag(
      request: TagRequest
  ): IO[AwsError, zio.aws.resourcegroups.model.TagResponse.ReadOnly]
  def updateGroup(
      request: UpdateGroupRequest
  ): IO[AwsError, zio.aws.resourcegroups.model.UpdateGroupResponse.ReadOnly]
  def groupResources(
      request: GroupResourcesRequest
  ): IO[AwsError, zio.aws.resourcegroups.model.GroupResourcesResponse.ReadOnly]
  def getGroup(
      request: GetGroupRequest
  ): IO[AwsError, zio.aws.resourcegroups.model.GetGroupResponse.ReadOnly]
  def listGroupResources(
      request: ListGroupResourcesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.resourcegroups.model.ListGroupResourcesResponse.ReadOnly,
    ReadOnly
  ]]
  def listGroupResourcesPaginated(request: ListGroupResourcesRequest): IO[
    AwsError,
    zio.aws.resourcegroups.model.ListGroupResourcesResponse.ReadOnly
  ]
  def getGroupConfiguration(request: GetGroupConfigurationRequest): IO[
    AwsError,
    zio.aws.resourcegroups.model.GetGroupConfigurationResponse.ReadOnly
  ]
  def ungroupResources(request: UngroupResourcesRequest): IO[
    AwsError,
    zio.aws.resourcegroups.model.UngroupResourcesResponse.ReadOnly
  ]
  def putGroupConfiguration(request: PutGroupConfigurationRequest): IO[
    AwsError,
    zio.aws.resourcegroups.model.PutGroupConfigurationResponse.ReadOnly
  ]
  def getTags(
      request: GetTagsRequest
  ): IO[AwsError, zio.aws.resourcegroups.model.GetTagsResponse.ReadOnly]
}
object ResourceGroups {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ResourceGroups] = customized(
    identity
  )
  def customized(
      customization: ResourceGroupsAsyncClientBuilder => ResourceGroupsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ResourceGroups] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: ResourceGroupsAsyncClientBuilder => ResourceGroupsAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, ResourceGroups] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = ResourceGroupsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[ResourceGroupsAsyncClient, ResourceGroupsAsyncClientBuilder](
        builder
      );
    b1 <- awsConfig.configureHttpClient[
      ResourceGroupsAsyncClient,
      ResourceGroupsAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new ResourceGroupsImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ResourceGroupsImpl[R](
      override val api: ResourceGroupsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ResourceGroups
      with AwsServiceBase[R] {
    override val serviceName: String = "ResourceGroups"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ResourceGroupsImpl[R1] = new ResourceGroupsImpl(api, newAspect, r)
    def getGroupQuery(request: GetGroupQueryRequest): IO[
      AwsError,
      zio.aws.resourcegroups.model.GetGroupQueryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.resourcegroups.model.GetGroupQueryRequest,
      GetGroupQueryResponse
    ]("getGroupQuery", api.getGroupQuery)(request.buildAwsValue())
      .map(zio.aws.resourcegroups.model.GetGroupQueryResponse.wrap)
      .provideEnvironment(r)
    def untag(
        request: UntagRequest
    ): IO[AwsError, zio.aws.resourcegroups.model.UntagResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.resourcegroups.model.UntagRequest,
        UntagResponse
      ]("untag", api.untag)(request.buildAwsValue())
        .map(zio.aws.resourcegroups.model.UntagResponse.wrap)
        .provideEnvironment(r)
    def deleteGroup(
        request: DeleteGroupRequest
    ): IO[AwsError, zio.aws.resourcegroups.model.DeleteGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.resourcegroups.model.DeleteGroupRequest,
        DeleteGroupResponse
      ]("deleteGroup", api.deleteGroup)(request.buildAwsValue())
        .map(zio.aws.resourcegroups.model.DeleteGroupResponse.wrap)
        .provideEnvironment(r)
    def listGroups(
        request: ListGroupsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.resourcegroups.model.ListGroupsResponse.ReadOnly,
      zio.aws.resourcegroups.model.Group.ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.resourcegroups.model.ListGroupsRequest,
      ListGroupsResponse,
      Group
    ](
      "listGroups",
      api.listGroups,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.groups().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.resourcegroups.model.ListGroupsResponse.wrap)
          .mapOutput(
            _.map(item => zio.aws.resourcegroups.model.Group.wrap(item))
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listGroupsPaginated(
        request: ListGroupsRequest
    ): IO[AwsError, zio.aws.resourcegroups.model.ListGroupsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.resourcegroups.model.ListGroupsRequest,
        ListGroupsResponse
      ]("listGroups", api.listGroups)(request.buildAwsValue())
        .map(zio.aws.resourcegroups.model.ListGroupsResponse.wrap)
        .provideEnvironment(r)
    def updateGroupQuery(request: UpdateGroupQueryRequest): IO[
      AwsError,
      zio.aws.resourcegroups.model.UpdateGroupQueryResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.resourcegroups.model.UpdateGroupQueryRequest,
      UpdateGroupQueryResponse
    ]("updateGroupQuery", api.updateGroupQuery)(request.buildAwsValue())
      .map(zio.aws.resourcegroups.model.UpdateGroupQueryResponse.wrap)
      .provideEnvironment(r)
    def searchResources(
        request: SearchResourcesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.resourcegroups.model.SearchResourcesResponse.ReadOnly,
      ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.resourcegroups.model.SearchResourcesRequest,
      SearchResourcesResponse,
      ResourceIdentifier
    ](
      "searchResources",
      api.searchResources,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.resourceIdentifiers().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.resourcegroups.model.SearchResourcesResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.resourcegroups.model.ResourceIdentifier.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def searchResourcesPaginated(request: SearchResourcesRequest): IO[
      AwsError,
      zio.aws.resourcegroups.model.SearchResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.resourcegroups.model.SearchResourcesRequest,
      SearchResourcesResponse
    ]("searchResources", api.searchResources)(request.buildAwsValue())
      .map(zio.aws.resourcegroups.model.SearchResourcesResponse.wrap)
      .provideEnvironment(r)
    def createGroup(
        request: CreateGroupRequest
    ): IO[AwsError, zio.aws.resourcegroups.model.CreateGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.resourcegroups.model.CreateGroupRequest,
        CreateGroupResponse
      ]("createGroup", api.createGroup)(request.buildAwsValue())
        .map(zio.aws.resourcegroups.model.CreateGroupResponse.wrap)
        .provideEnvironment(r)
    def tag(
        request: TagRequest
    ): IO[AwsError, zio.aws.resourcegroups.model.TagResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.resourcegroups.model.TagRequest,
        TagResponse
      ]("tag", api.tag)(request.buildAwsValue())
        .map(zio.aws.resourcegroups.model.TagResponse.wrap)
        .provideEnvironment(r)
    def updateGroup(
        request: UpdateGroupRequest
    ): IO[AwsError, zio.aws.resourcegroups.model.UpdateGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.resourcegroups.model.UpdateGroupRequest,
        UpdateGroupResponse
      ]("updateGroup", api.updateGroup)(request.buildAwsValue())
        .map(zio.aws.resourcegroups.model.UpdateGroupResponse.wrap)
        .provideEnvironment(r)
    def groupResources(request: GroupResourcesRequest): IO[
      AwsError,
      zio.aws.resourcegroups.model.GroupResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.resourcegroups.model.GroupResourcesRequest,
      GroupResourcesResponse
    ]("groupResources", api.groupResources)(request.buildAwsValue())
      .map(zio.aws.resourcegroups.model.GroupResourcesResponse.wrap)
      .provideEnvironment(r)
    def getGroup(
        request: GetGroupRequest
    ): IO[AwsError, zio.aws.resourcegroups.model.GetGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.resourcegroups.model.GetGroupRequest,
        GetGroupResponse
      ]("getGroup", api.getGroup)(request.buildAwsValue())
        .map(zio.aws.resourcegroups.model.GetGroupResponse.wrap)
        .provideEnvironment(r)
    def listGroupResources(
        request: ListGroupResourcesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.resourcegroups.model.ListGroupResourcesResponse.ReadOnly,
      ReadOnly
    ]] = asyncPaginatedRequest[
      software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesRequest,
      ListGroupResourcesResponse,
      ResourceIdentifier
    ](
      "listGroupResources",
      api.listGroupResources,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.resourceIdentifiers().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.resourcegroups.model.ListGroupResourcesResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.resourcegroups.model.ResourceIdentifier.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listGroupResourcesPaginated(request: ListGroupResourcesRequest): IO[
      AwsError,
      zio.aws.resourcegroups.model.ListGroupResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesRequest,
      ListGroupResourcesResponse
    ]("listGroupResources", api.listGroupResources)(request.buildAwsValue())
      .map(zio.aws.resourcegroups.model.ListGroupResourcesResponse.wrap)
      .provideEnvironment(r)
    def getGroupConfiguration(request: GetGroupConfigurationRequest): IO[
      AwsError,
      zio.aws.resourcegroups.model.GetGroupConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.resourcegroups.model.GetGroupConfigurationRequest,
      GetGroupConfigurationResponse
    ]("getGroupConfiguration", api.getGroupConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.resourcegroups.model.GetGroupConfigurationResponse.wrap)
      .provideEnvironment(r)
    def ungroupResources(request: UngroupResourcesRequest): IO[
      AwsError,
      zio.aws.resourcegroups.model.UngroupResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.resourcegroups.model.UngroupResourcesRequest,
      UngroupResourcesResponse
    ]("ungroupResources", api.ungroupResources)(request.buildAwsValue())
      .map(zio.aws.resourcegroups.model.UngroupResourcesResponse.wrap)
      .provideEnvironment(r)
    def putGroupConfiguration(request: PutGroupConfigurationRequest): IO[
      AwsError,
      zio.aws.resourcegroups.model.PutGroupConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.resourcegroups.model.PutGroupConfigurationRequest,
      PutGroupConfigurationResponse
    ]("putGroupConfiguration", api.putGroupConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.resourcegroups.model.PutGroupConfigurationResponse.wrap)
      .provideEnvironment(r)
    def getTags(
        request: GetTagsRequest
    ): IO[AwsError, zio.aws.resourcegroups.model.GetTagsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.resourcegroups.model.GetTagsRequest,
        GetTagsResponse
      ]("getTags", api.getTags)(request.buildAwsValue())
        .map(zio.aws.resourcegroups.model.GetTagsResponse.wrap)
        .provideEnvironment(r)
  }
  def getGroupQuery(request: GetGroupQueryRequest): ZIO[
    zio.aws.resourcegroups.ResourceGroups,
    AwsError,
    zio.aws.resourcegroups.model.GetGroupQueryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGroupQuery(request))
  def untag(request: UntagRequest): ZIO[
    zio.aws.resourcegroups.ResourceGroups,
    AwsError,
    zio.aws.resourcegroups.model.UntagResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untag(request))
  def deleteGroup(request: DeleteGroupRequest): ZIO[
    zio.aws.resourcegroups.ResourceGroups,
    AwsError,
    zio.aws.resourcegroups.model.DeleteGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteGroup(request))
  def listGroups(
      request: ListGroupsRequest
  ): ZIO[zio.aws.resourcegroups.ResourceGroups, AwsError, StreamingOutputResult[
    Any,
    zio.aws.resourcegroups.model.ListGroupsResponse.ReadOnly,
    zio.aws.resourcegroups.model.Group.ReadOnly
  ]] = ZIO.serviceWithZIO(_.listGroups(request))
  def listGroupsPaginated(request: ListGroupsRequest): ZIO[
    zio.aws.resourcegroups.ResourceGroups,
    AwsError,
    zio.aws.resourcegroups.model.ListGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGroupsPaginated(request))
  def updateGroupQuery(request: UpdateGroupQueryRequest): ZIO[
    zio.aws.resourcegroups.ResourceGroups,
    AwsError,
    zio.aws.resourcegroups.model.UpdateGroupQueryResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGroupQuery(request))
  def searchResources(
      request: SearchResourcesRequest
  ): ZIO[zio.aws.resourcegroups.ResourceGroups, AwsError, StreamingOutputResult[
    Any,
    zio.aws.resourcegroups.model.SearchResourcesResponse.ReadOnly,
    ReadOnly
  ]] = ZIO.serviceWithZIO(_.searchResources(request))
  def searchResourcesPaginated(request: SearchResourcesRequest): ZIO[
    zio.aws.resourcegroups.ResourceGroups,
    AwsError,
    zio.aws.resourcegroups.model.SearchResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.searchResourcesPaginated(request))
  def createGroup(request: CreateGroupRequest): ZIO[
    zio.aws.resourcegroups.ResourceGroups,
    AwsError,
    zio.aws.resourcegroups.model.CreateGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGroup(request))
  def tag(request: TagRequest): ZIO[
    zio.aws.resourcegroups.ResourceGroups,
    AwsError,
    zio.aws.resourcegroups.model.TagResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tag(request))
  def updateGroup(request: UpdateGroupRequest): ZIO[
    zio.aws.resourcegroups.ResourceGroups,
    AwsError,
    zio.aws.resourcegroups.model.UpdateGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGroup(request))
  def groupResources(request: GroupResourcesRequest): ZIO[
    zio.aws.resourcegroups.ResourceGroups,
    AwsError,
    zio.aws.resourcegroups.model.GroupResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.groupResources(request))
  def getGroup(request: GetGroupRequest): ZIO[
    zio.aws.resourcegroups.ResourceGroups,
    AwsError,
    zio.aws.resourcegroups.model.GetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGroup(request))
  def listGroupResources(
      request: ListGroupResourcesRequest
  ): ZIO[zio.aws.resourcegroups.ResourceGroups, AwsError, StreamingOutputResult[
    Any,
    zio.aws.resourcegroups.model.ListGroupResourcesResponse.ReadOnly,
    ReadOnly
  ]] = ZIO.serviceWithZIO(_.listGroupResources(request))
  def listGroupResourcesPaginated(request: ListGroupResourcesRequest): ZIO[
    zio.aws.resourcegroups.ResourceGroups,
    AwsError,
    zio.aws.resourcegroups.model.ListGroupResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGroupResourcesPaginated(request))
  def getGroupConfiguration(request: GetGroupConfigurationRequest): ZIO[
    zio.aws.resourcegroups.ResourceGroups,
    AwsError,
    zio.aws.resourcegroups.model.GetGroupConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getGroupConfiguration(request))
  def ungroupResources(request: UngroupResourcesRequest): ZIO[
    zio.aws.resourcegroups.ResourceGroups,
    AwsError,
    zio.aws.resourcegroups.model.UngroupResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.ungroupResources(request))
  def putGroupConfiguration(request: PutGroupConfigurationRequest): ZIO[
    zio.aws.resourcegroups.ResourceGroups,
    AwsError,
    zio.aws.resourcegroups.model.PutGroupConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putGroupConfiguration(request))
  def getTags(request: GetTagsRequest): ZIO[
    zio.aws.resourcegroups.ResourceGroups,
    AwsError,
    zio.aws.resourcegroups.model.GetTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getTags(request))
}
