package zio.aws.resourcegroups.model
import zio.aws.resourcegroups.model.primitives.{NextToken, MaxResults}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SearchResourcesRequest(
    resourceQuery: zio.aws.resourcegroups.model.ResourceQuery,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.SearchResourcesRequest = {
    import SearchResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.SearchResourcesRequest
      .builder()
      .resourceQuery(resourceQuery.buildAwsValue())
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.SearchResourcesRequest.ReadOnly =
    zio.aws.resourcegroups.model.SearchResourcesRequest.wrap(buildAwsValue())
}
object SearchResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.SearchResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.SearchResourcesRequest =
      zio.aws.resourcegroups.model.SearchResourcesRequest(
        resourceQuery.asEditable,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def resourceQuery: zio.aws.resourcegroups.model.ResourceQuery.ReadOnly
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getResourceQuery: ZIO[
      Any,
      Nothing,
      zio.aws.resourcegroups.model.ResourceQuery.ReadOnly
    ] = ZIO.succeed(resourceQuery)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.SearchResourcesRequest
  ) extends zio.aws.resourcegroups.model.SearchResourcesRequest.ReadOnly {
    override val resourceQuery
        : zio.aws.resourcegroups.model.ResourceQuery.ReadOnly =
      zio.aws.resourcegroups.model.ResourceQuery.wrap(impl.resourceQuery())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.resourcegroups.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.resourcegroups.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.SearchResourcesRequest
  ): zio.aws.resourcegroups.model.SearchResourcesRequest.ReadOnly = new Wrapper(
    impl
  )
}
