package zio.aws.resourcegroups.model
import scala.jdk.CollectionConverters.*
sealed trait QueryType {
  def unwrap: software.amazon.awssdk.services.resourcegroups.model.QueryType
}
object QueryType {
  def wrap(
      value: software.amazon.awssdk.services.resourcegroups.model.QueryType
  ): zio.aws.resourcegroups.model.QueryType = value match {
    case software.amazon.awssdk.services.resourcegroups.model.QueryType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.resourcegroups.model.QueryType.TAG_FILTERS_1_0 =>
      val r = TAG_FILTERS_1_0
      r
    case software.amazon.awssdk.services.resourcegroups.model.QueryType.CLOUDFORMATION_STACK_1_0 =>
      val r = CLOUDFORMATION_STACK_1_0
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.resourcegroups.model.QueryType {
    override def unwrap
        : software.amazon.awssdk.services.resourcegroups.model.QueryType =
      software.amazon.awssdk.services.resourcegroups.model.QueryType.UNKNOWN_TO_SDK_VERSION
  }
  case object TAG_FILTERS_1_0 extends zio.aws.resourcegroups.model.QueryType {
    override def unwrap
        : software.amazon.awssdk.services.resourcegroups.model.QueryType =
      software.amazon.awssdk.services.resourcegroups.model.QueryType.TAG_FILTERS_1_0
  }
  case object CLOUDFORMATION_STACK_1_0
      extends zio.aws.resourcegroups.model.QueryType {
    override def unwrap
        : software.amazon.awssdk.services.resourcegroups.model.QueryType =
      software.amazon.awssdk.services.resourcegroups.model.QueryType.CLOUDFORMATION_STACK_1_0
  }
}
