package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.resourcegroups.model.primitives.GroupConfigurationType
import scala.jdk.CollectionConverters.*
final case class GroupConfigurationItem(
    `type`: GroupConfigurationType,
    parameters: Optional[
      Iterable[zio.aws.resourcegroups.model.GroupConfigurationParameter]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationItem = {
    import GroupConfigurationItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationItem
      .builder()
      .`type`(GroupConfigurationType.unwrap(`type`): java.lang.String)
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.GroupConfigurationItem.ReadOnly =
    zio.aws.resourcegroups.model.GroupConfigurationItem.wrap(buildAwsValue())
}
object GroupConfigurationItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.GroupConfigurationItem =
      zio.aws.resourcegroups.model.GroupConfigurationItem(
        `type`,
        parameters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def `type`: GroupConfigurationType
    def parameters: Optional[
      List[zio.aws.resourcegroups.model.GroupConfigurationParameter.ReadOnly]
    ]
    def getType: ZIO[Any, Nothing, GroupConfigurationType] = ZIO.succeed(`type`)
    def getParameters: ZIO[Any, AwsError, List[
      zio.aws.resourcegroups.model.GroupConfigurationParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationItem
  ) extends zio.aws.resourcegroups.model.GroupConfigurationItem.ReadOnly {
    override val `type`: GroupConfigurationType =
      zio.aws.resourcegroups.model.primitives
        .GroupConfigurationType(impl.`type`())
    override val parameters: Optional[
      List[zio.aws.resourcegroups.model.GroupConfigurationParameter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.resourcegroups.model.GroupConfigurationParameter.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.GroupConfigurationItem
  ): zio.aws.resourcegroups.model.GroupConfigurationItem.ReadOnly = new Wrapper(
    impl
  )
}
