package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.resourcegroups.model.primitives.GroupConfigurationFailureReason
import scala.jdk.CollectionConverters.*
final case class GroupConfiguration(
    configuration: Optional[
      Iterable[zio.aws.resourcegroups.model.GroupConfigurationItem]
    ] = Optional.Absent,
    proposedConfiguration: Optional[
      Iterable[zio.aws.resourcegroups.model.GroupConfigurationItem]
    ] = Optional.Absent,
    status: Optional[zio.aws.resourcegroups.model.GroupConfigurationStatus] =
      Optional.Absent,
    failureReason: Optional[GroupConfigurationFailureReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.GroupConfiguration = {
    import GroupConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.GroupConfiguration
      .builder()
      .optionallyWith(
        configuration.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configuration)
      .optionallyWith(
        proposedConfiguration.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.proposedConfiguration)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        failureReason.map(value =>
          GroupConfigurationFailureReason.unwrap(value): java.lang.String
        )
      )(_.failureReason)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.GroupConfiguration.ReadOnly =
    zio.aws.resourcegroups.model.GroupConfiguration.wrap(buildAwsValue())
}
object GroupConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.GroupConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.GroupConfiguration =
      zio.aws.resourcegroups.model.GroupConfiguration(
        configuration.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        proposedConfiguration.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        status.map(value => value),
        failureReason.map(value => value)
      )
    def configuration: Optional[
      List[zio.aws.resourcegroups.model.GroupConfigurationItem.ReadOnly]
    ]
    def proposedConfiguration: Optional[
      List[zio.aws.resourcegroups.model.GroupConfigurationItem.ReadOnly]
    ]
    def status: Optional[zio.aws.resourcegroups.model.GroupConfigurationStatus]
    def failureReason: Optional[GroupConfigurationFailureReason]
    def getConfiguration: ZIO[Any, AwsError, List[
      zio.aws.resourcegroups.model.GroupConfigurationItem.ReadOnly
    ]] = AwsError.unwrapOptionField("configuration", configuration)
    def getProposedConfiguration: ZIO[Any, AwsError, List[
      zio.aws.resourcegroups.model.GroupConfigurationItem.ReadOnly
    ]] =
      AwsError.unwrapOptionField("proposedConfiguration", proposedConfiguration)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.resourcegroups.model.GroupConfigurationStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getFailureReason: ZIO[Any, AwsError, GroupConfigurationFailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.GroupConfiguration
  ) extends zio.aws.resourcegroups.model.GroupConfiguration.ReadOnly {
    override val configuration: Optional[
      List[zio.aws.resourcegroups.model.GroupConfigurationItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.configuration())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.resourcegroups.model.GroupConfigurationItem.wrap(item)
        }.toList
      )
    override val proposedConfiguration: Optional[
      List[zio.aws.resourcegroups.model.GroupConfigurationItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.proposedConfiguration())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.resourcegroups.model.GroupConfigurationItem.wrap(item)
        }.toList
      )
    override val status
        : Optional[zio.aws.resourcegroups.model.GroupConfigurationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.resourcegroups.model.GroupConfigurationStatus.wrap(value)
        )
    override val failureReason: Optional[GroupConfigurationFailureReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureReason())
        .map(value =>
          zio.aws.resourcegroups.model.primitives
            .GroupConfigurationFailureReason(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.GroupConfiguration
  ): zio.aws.resourcegroups.model.GroupConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
