package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateGroupQueryResponse(
    groupQuery: Optional[zio.aws.resourcegroups.model.GroupQuery] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.UpdateGroupQueryResponse = {
    import UpdateGroupQueryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.UpdateGroupQueryResponse
      .builder()
      .optionallyWith(groupQuery.map(value => value.buildAwsValue()))(
        _.groupQuery
      )
      .build()
  }
  def asReadOnly
      : zio.aws.resourcegroups.model.UpdateGroupQueryResponse.ReadOnly =
    zio.aws.resourcegroups.model.UpdateGroupQueryResponse.wrap(buildAwsValue())
}
object UpdateGroupQueryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.UpdateGroupQueryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.UpdateGroupQueryResponse =
      zio.aws.resourcegroups.model
        .UpdateGroupQueryResponse(groupQuery.map(value => value.asEditable))
    def groupQuery: Optional[zio.aws.resourcegroups.model.GroupQuery.ReadOnly]
    def getGroupQuery
        : ZIO[Any, AwsError, zio.aws.resourcegroups.model.GroupQuery.ReadOnly] =
      AwsError.unwrapOptionField("groupQuery", groupQuery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.UpdateGroupQueryResponse
  ) extends zio.aws.resourcegroups.model.UpdateGroupQueryResponse.ReadOnly {
    override val groupQuery
        : Optional[zio.aws.resourcegroups.model.GroupQuery.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupQuery())
        .map(value => zio.aws.resourcegroups.model.GroupQuery.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.UpdateGroupQueryResponse
  ): zio.aws.resourcegroups.model.UpdateGroupQueryResponse.ReadOnly =
    new Wrapper(impl)
}
