package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.resourcegroups.model.primitives.{
  Description,
  GroupName,
  GroupArn
}
import scala.jdk.CollectionConverters.*
final case class Group(
    groupArn: GroupArn,
    name: GroupName,
    description: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.Group = {
    import Group.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.Group
      .builder()
      .groupArn(GroupArn.unwrap(groupArn): java.lang.String)
      .name(GroupName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.Group.ReadOnly =
    zio.aws.resourcegroups.model.Group.wrap(buildAwsValue())
}
object Group {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.Group
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.Group =
      zio.aws.resourcegroups.model
        .Group(groupArn, name, description.map(value => value))
    def groupArn: GroupArn
    def name: GroupName
    def description: Optional[Description]
    def getGroupArn: ZIO[Any, Nothing, GroupArn] = ZIO.succeed(groupArn)
    def getName: ZIO[Any, Nothing, GroupName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.Group
  ) extends zio.aws.resourcegroups.model.Group.ReadOnly {
    override val groupArn: GroupArn =
      zio.aws.resourcegroups.model.primitives.GroupArn(impl.groupArn())
    override val name: GroupName =
      zio.aws.resourcegroups.model.primitives.GroupName(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.resourcegroups.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.Group
  ): zio.aws.resourcegroups.model.Group.ReadOnly = new Wrapper(impl)
}
