package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.resourcegroups.model.primitives.Query
import scala.jdk.CollectionConverters.*
final case class ResourceQuery(
    `type`: zio.aws.resourcegroups.model.QueryType,
    query: Query
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.ResourceQuery = {
    import ResourceQuery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.ResourceQuery
      .builder()
      .`type`(`type`.unwrap)
      .query(Query.unwrap(query): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.ResourceQuery.ReadOnly =
    zio.aws.resourcegroups.model.ResourceQuery.wrap(buildAwsValue())
}
object ResourceQuery {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.ResourceQuery
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.ResourceQuery =
      zio.aws.resourcegroups.model.ResourceQuery(`type`, query)
    def `type`: zio.aws.resourcegroups.model.QueryType
    def query: Query
    def getType: ZIO[Any, Nothing, zio.aws.resourcegroups.model.QueryType] =
      ZIO.succeed(`type`)
    def getQuery: ZIO[Any, Nothing, Query] = ZIO.succeed(query)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.ResourceQuery
  ) extends zio.aws.resourcegroups.model.ResourceQuery.ReadOnly {
    override val `type`: zio.aws.resourcegroups.model.QueryType =
      zio.aws.resourcegroups.model.QueryType.wrap(impl.`type`())
    override val query: Query =
      zio.aws.resourcegroups.model.primitives.Query(impl.query())
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.ResourceQuery
  ): zio.aws.resourcegroups.model.ResourceQuery.ReadOnly = new Wrapper(impl)
}
