package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetGroupConfigurationResponse(
    groupConfiguration: Optional[
      zio.aws.resourcegroups.model.GroupConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.GetGroupConfigurationResponse = {
    import GetGroupConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.GetGroupConfigurationResponse
      .builder()
      .optionallyWith(groupConfiguration.map(value => value.buildAwsValue()))(
        _.groupConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.resourcegroups.model.GetGroupConfigurationResponse.ReadOnly =
    zio.aws.resourcegroups.model.GetGroupConfigurationResponse
      .wrap(buildAwsValue())
}
object GetGroupConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.GetGroupConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.GetGroupConfigurationResponse =
      zio.aws.resourcegroups.model.GetGroupConfigurationResponse(
        groupConfiguration.map(value => value.asEditable)
      )
    def groupConfiguration
        : Optional[zio.aws.resourcegroups.model.GroupConfiguration.ReadOnly]
    def getGroupConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.resourcegroups.model.GroupConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("groupConfiguration", groupConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.GetGroupConfigurationResponse
  ) extends zio.aws.resourcegroups.model.GetGroupConfigurationResponse.ReadOnly {
    override val groupConfiguration
        : Optional[zio.aws.resourcegroups.model.GroupConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupConfiguration())
        .map(value =>
          zio.aws.resourcegroups.model.GroupConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.GetGroupConfigurationResponse
  ): zio.aws.resourcegroups.model.GetGroupConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
