package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.resourcegroups.model.primitives.{TagValue, TagKey, GroupArn}
import scala.jdk.CollectionConverters.*
final case class TagResponse(
    arn: Optional[GroupArn] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.TagResponse = {
    import TagResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.TagResponse
      .builder()
      .optionallyWith(
        arn.map(value => GroupArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.TagResponse.ReadOnly =
    zio.aws.resourcegroups.model.TagResponse.wrap(buildAwsValue())
}
object TagResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.TagResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.TagResponse =
      zio.aws.resourcegroups.model
        .TagResponse(arn.map(value => value), tags.map(value => value))
    def arn: Optional[GroupArn]
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, GroupArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.TagResponse
  ) extends zio.aws.resourcegroups.model.TagResponse.ReadOnly {
    override val arn: Optional[GroupArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.resourcegroups.model.primitives.GroupArn(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.resourcegroups.model.primitives.TagKey(
              key
            ) -> zio.aws.resourcegroups.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.TagResponse
  ): zio.aws.resourcegroups.model.TagResponse.ReadOnly = new Wrapper(impl)
}
