package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListGroupResourcesItem(
    identifier: Optional[zio.aws.resourcegroups.model.ResourceIdentifier] =
      Optional.Absent,
    status: Optional[zio.aws.resourcegroups.model.ResourceStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesItem = {
    import ListGroupResourcesItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesItem
      .builder()
      .optionallyWith(identifier.map(value => value.buildAwsValue()))(
        _.identifier
      )
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.ListGroupResourcesItem.ReadOnly =
    zio.aws.resourcegroups.model.ListGroupResourcesItem.wrap(buildAwsValue())
}
object ListGroupResourcesItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.ListGroupResourcesItem =
      zio.aws.resourcegroups.model.ListGroupResourcesItem(
        identifier.map(value => value.asEditable),
        status.map(value => value.asEditable)
      )
    def identifier
        : Optional[zio.aws.resourcegroups.model.ResourceIdentifier.ReadOnly]
    def status: Optional[zio.aws.resourcegroups.model.ResourceStatus.ReadOnly]
    def getIdentifier: ZIO[
      Any,
      AwsError,
      zio.aws.resourcegroups.model.ResourceIdentifier.ReadOnly
    ] = AwsError.unwrapOptionField("identifier", identifier)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.resourcegroups.model.ResourceStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesItem
  ) extends zio.aws.resourcegroups.model.ListGroupResourcesItem.ReadOnly {
    override val identifier
        : Optional[zio.aws.resourcegroups.model.ResourceIdentifier.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identifier())
        .map(value =>
          zio.aws.resourcegroups.model.ResourceIdentifier.wrap(value)
        )
    override val status
        : Optional[zio.aws.resourcegroups.model.ResourceStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.resourcegroups.model.ResourceStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesItem
  ): zio.aws.resourcegroups.model.ListGroupResourcesItem.ReadOnly = new Wrapper(
    impl
  )
}
