package zio.aws.resourcegroups.model
import zio.aws.resourcegroups.model.primitives.{
  NextToken,
  MaxResults,
  GroupString,
  GroupName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListGroupResourcesRequest(
    groupName: Optional[GroupName] = Optional.Absent,
    group: Optional[GroupString] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.resourcegroups.model.ResourceFilter]] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesRequest = {
    import ListGroupResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesRequest
      .builder()
      .optionallyWith(
        groupName.map(value => GroupName.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        group.map(value => GroupString.unwrap(value): java.lang.String)
      )(_.group)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.resourcegroups.model.ListGroupResourcesRequest.ReadOnly =
    zio.aws.resourcegroups.model.ListGroupResourcesRequest.wrap(buildAwsValue())
}
object ListGroupResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.ListGroupResourcesRequest =
      zio.aws.resourcegroups.model.ListGroupResourcesRequest(
        groupName.map(value => value),
        group.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def groupName: Optional[GroupName]
    def group: Optional[GroupString]
    def filters
        : Optional[List[zio.aws.resourcegroups.model.ResourceFilter.ReadOnly]]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getGroupName: ZIO[Any, AwsError, GroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroup: ZIO[Any, AwsError, GroupString] =
      AwsError.unwrapOptionField("group", group)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.resourcegroups.model.ResourceFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesRequest
  ) extends zio.aws.resourcegroups.model.ListGroupResourcesRequest.ReadOnly {
    override val groupName: Optional[GroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.resourcegroups.model.primitives.GroupName(value))
    override val group: Optional[GroupString] = zio.aws.core.internal
      .optionalFromNullable(impl.group())
      .map(value => zio.aws.resourcegroups.model.primitives.GroupString(value))
    override val filters
        : Optional[List[zio.aws.resourcegroups.model.ResourceFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.resourcegroups.model.ResourceFilter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.resourcegroups.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.resourcegroups.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesRequest
  ): zio.aws.resourcegroups.model.ListGroupResourcesRequest.ReadOnly =
    new Wrapper(impl)
}
