package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.resourcegroups.model.primitives.GroupString
import scala.jdk.CollectionConverters.*
final case class PutGroupConfigurationRequest(
    group: Option[GroupString] = None,
    configuration: Option[
      Iterable[zio.aws.resourcegroups.model.GroupConfigurationItem]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.PutGroupConfigurationRequest = {
    import PutGroupConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.PutGroupConfigurationRequest
      .builder()
      .optionallyWith(
        group.map(value => GroupString.unwrap(value): java.lang.String)
      )(_.group)
      .optionallyWith(
        configuration.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configuration)
      .build()
  }
  def asReadOnly
      : zio.aws.resourcegroups.model.PutGroupConfigurationRequest.ReadOnly =
    zio.aws.resourcegroups.model.PutGroupConfigurationRequest
      .wrap(buildAwsValue())
}
object PutGroupConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.PutGroupConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.PutGroupConfigurationRequest =
      zio.aws.resourcegroups.model.PutGroupConfigurationRequest(
        group.map(value => value),
        configuration.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def group: Option[GroupString]
    def configuration: Option[
      List[zio.aws.resourcegroups.model.GroupConfigurationItem.ReadOnly]
    ]
    def getGroup: ZIO[Any, AwsError, GroupString] =
      AwsError.unwrapOptionField("group", group)
    def getConfiguration: ZIO[Any, AwsError, List[
      zio.aws.resourcegroups.model.GroupConfigurationItem.ReadOnly
    ]] = AwsError.unwrapOptionField("configuration", configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.PutGroupConfigurationRequest
  ) extends zio.aws.resourcegroups.model.PutGroupConfigurationRequest.ReadOnly {
    override val group: Option[GroupString] = scala
      .Option(impl.group())
      .map(value => zio.aws.resourcegroups.model.primitives.GroupString(value))
    override val configuration: Option[
      List[zio.aws.resourcegroups.model.GroupConfigurationItem.ReadOnly]
    ] = scala
      .Option(impl.configuration())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.resourcegroups.model.GroupConfigurationItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.PutGroupConfigurationRequest
  ): zio.aws.resourcegroups.model.PutGroupConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
