package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ResourceStatus(
    name: Option[zio.aws.resourcegroups.model.ResourceStatusValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.ResourceStatus = {
    import ResourceStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.ResourceStatus
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.ResourceStatus.ReadOnly =
    zio.aws.resourcegroups.model.ResourceStatus.wrap(buildAwsValue())
}
object ResourceStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.ResourceStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.ResourceStatus =
      zio.aws.resourcegroups.model.ResourceStatus(name.map(value => value))
    def name: Option[zio.aws.resourcegroups.model.ResourceStatusValue]
    def getName
        : ZIO[Any, AwsError, zio.aws.resourcegroups.model.ResourceStatusValue] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.ResourceStatus
  ) extends zio.aws.resourcegroups.model.ResourceStatus.ReadOnly {
    override val name
        : Option[zio.aws.resourcegroups.model.ResourceStatusValue] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.resourcegroups.model.ResourceStatusValue.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.ResourceStatus
  ): zio.aws.resourcegroups.model.ResourceStatus.ReadOnly = new Wrapper(impl)
}
