package zio.aws.resourcegroups.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.resourcegroups.model.primitives.{NextToken, MaxResults}
import scala.jdk.CollectionConverters.*
final case class ListGroupsRequest(
    filters: Option[Iterable[zio.aws.resourcegroups.model.GroupFilter]] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.ListGroupsRequest = {
    import ListGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.ListGroupsRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.ListGroupsRequest.ReadOnly =
    zio.aws.resourcegroups.model.ListGroupsRequest.wrap(buildAwsValue())
}
object ListGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.ListGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.ListGroupsRequest =
      zio.aws.resourcegroups.model.ListGroupsRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters: Option[List[zio.aws.resourcegroups.model.GroupFilter.ReadOnly]]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.resourcegroups.model.GroupFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.ListGroupsRequest
  ) extends zio.aws.resourcegroups.model.ListGroupsRequest.ReadOnly {
    override val filters
        : Option[List[zio.aws.resourcegroups.model.GroupFilter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.resourcegroups.model.GroupFilter.wrap(item)
          }.toList
        )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.resourcegroups.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.resourcegroups.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.ListGroupsRequest
  ): zio.aws.resourcegroups.model.ListGroupsRequest.ReadOnly = new Wrapper(impl)
}
