package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.resourcegroups.model.primitives.GroupString
import scala.jdk.CollectionConverters.*
final case class GetGroupConfigurationRequest(
    group: Option[GroupString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.GetGroupConfigurationRequest = {
    import GetGroupConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.GetGroupConfigurationRequest
      .builder()
      .optionallyWith(
        group.map(value => GroupString.unwrap(value): java.lang.String)
      )(_.group)
      .build()
  }
  def asReadOnly
      : zio.aws.resourcegroups.model.GetGroupConfigurationRequest.ReadOnly =
    zio.aws.resourcegroups.model.GetGroupConfigurationRequest
      .wrap(buildAwsValue())
}
object GetGroupConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.GetGroupConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.GetGroupConfigurationRequest =
      zio.aws.resourcegroups.model
        .GetGroupConfigurationRequest(group.map(value => value))
    def group: Option[GroupString]
    def getGroup: ZIO[Any, AwsError, GroupString] =
      AwsError.unwrapOptionField("group", group)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.GetGroupConfigurationRequest
  ) extends zio.aws.resourcegroups.model.GetGroupConfigurationRequest.ReadOnly {
    override val group: Option[GroupString] = scala
      .Option(impl.group())
      .map(value => zio.aws.resourcegroups.model.primitives.GroupString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.GetGroupConfigurationRequest
  ): zio.aws.resourcegroups.model.GetGroupConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
