package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.resourcegroups.model.primitives.{
  Description,
  GroupString,
  GroupName
}
import scala.jdk.CollectionConverters.*
final case class UpdateGroupRequest(
    groupName: Option[GroupName] = None,
    group: Option[GroupString] = None,
    description: Option[Description] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.UpdateGroupRequest = {
    import UpdateGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.UpdateGroupRequest
      .builder()
      .optionallyWith(
        groupName.map(value => GroupName.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        group.map(value => GroupString.unwrap(value): java.lang.String)
      )(_.group)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.UpdateGroupRequest.ReadOnly =
    zio.aws.resourcegroups.model.UpdateGroupRequest.wrap(buildAwsValue())
}
object UpdateGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.UpdateGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.UpdateGroupRequest =
      zio.aws.resourcegroups.model.UpdateGroupRequest(
        groupName.map(value => value),
        group.map(value => value),
        description.map(value => value)
      )
    def groupName: Option[GroupName]
    def group: Option[GroupString]
    def description: Option[Description]
    def getGroupName: ZIO[Any, AwsError, GroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroup: ZIO[Any, AwsError, GroupString] =
      AwsError.unwrapOptionField("group", group)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.UpdateGroupRequest
  ) extends zio.aws.resourcegroups.model.UpdateGroupRequest.ReadOnly {
    override val groupName: Option[GroupName] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.resourcegroups.model.primitives.GroupName(value))
    override val group: Option[GroupString] = scala
      .Option(impl.group())
      .map(value => zio.aws.resourcegroups.model.primitives.GroupString(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.resourcegroups.model.primitives.Description(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.UpdateGroupRequest
  ): zio.aws.resourcegroups.model.UpdateGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
