package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetGroupQueryResponse(
    groupQuery: Option[zio.aws.resourcegroups.model.GroupQuery] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.GetGroupQueryResponse = {
    import GetGroupQueryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.GetGroupQueryResponse
      .builder()
      .optionallyWith(groupQuery.map(value => value.buildAwsValue()))(
        _.groupQuery
      )
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.GetGroupQueryResponse.ReadOnly =
    zio.aws.resourcegroups.model.GetGroupQueryResponse.wrap(buildAwsValue())
}
object GetGroupQueryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.GetGroupQueryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.GetGroupQueryResponse =
      zio.aws.resourcegroups.model
        .GetGroupQueryResponse(groupQuery.map(value => value.asEditable))
    def groupQuery: Option[zio.aws.resourcegroups.model.GroupQuery.ReadOnly]
    def getGroupQuery
        : ZIO[Any, AwsError, zio.aws.resourcegroups.model.GroupQuery.ReadOnly] =
      AwsError.unwrapOptionField("groupQuery", groupQuery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.GetGroupQueryResponse
  ) extends zio.aws.resourcegroups.model.GetGroupQueryResponse.ReadOnly {
    override val groupQuery
        : Option[zio.aws.resourcegroups.model.GroupQuery.ReadOnly] = scala
      .Option(impl.groupQuery())
      .map(value => zio.aws.resourcegroups.model.GroupQuery.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.GetGroupQueryResponse
  ): zio.aws.resourcegroups.model.GetGroupQueryResponse.ReadOnly = new Wrapper(
    impl
  )
}
