package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.resourcegroups.model.primitives.{GroupArn, GroupName}
import scala.jdk.CollectionConverters.*
final case class GroupIdentifier(
    groupName: Option[GroupName] = None,
    groupArn: Option[GroupArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.GroupIdentifier = {
    import GroupIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.GroupIdentifier
      .builder()
      .optionallyWith(
        groupName.map(value => GroupName.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        groupArn.map(value => GroupArn.unwrap(value): java.lang.String)
      )(_.groupArn)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.GroupIdentifier.ReadOnly =
    zio.aws.resourcegroups.model.GroupIdentifier.wrap(buildAwsValue())
}
object GroupIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.GroupIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.GroupIdentifier =
      zio.aws.resourcegroups.model.GroupIdentifier(
        groupName.map(value => value),
        groupArn.map(value => value)
      )
    def groupName: Option[GroupName]
    def groupArn: Option[GroupArn]
    def getGroupName: ZIO[Any, AwsError, GroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroupArn: ZIO[Any, AwsError, GroupArn] =
      AwsError.unwrapOptionField("groupArn", groupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.GroupIdentifier
  ) extends zio.aws.resourcegroups.model.GroupIdentifier.ReadOnly {
    override val groupName: Option[GroupName] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.resourcegroups.model.primitives.GroupName(value))
    override val groupArn: Option[GroupArn] = scala
      .Option(impl.groupArn())
      .map(value => zio.aws.resourcegroups.model.primitives.GroupArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.GroupIdentifier
  ): zio.aws.resourcegroups.model.GroupIdentifier.ReadOnly = new Wrapper(impl)
}
