package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.resourcegroups.model.primitives.{
  TagValue,
  TagKey,
  Description,
  GroupName
}
import scala.jdk.CollectionConverters._
final case class CreateGroupRequest(
    name: GroupName,
    description: Optional[Description] = Optional.Absent,
    resourceQuery: Optional[zio.aws.resourcegroups.model.ResourceQuery] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    configuration: Optional[
      Iterable[zio.aws.resourcegroups.model.GroupConfigurationItem]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.CreateGroupRequest = {
    import CreateGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.CreateGroupRequest
      .builder()
      .name(GroupName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(resourceQuery.map(value => value.buildAwsValue()))(
        _.resourceQuery
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        configuration.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configuration)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.CreateGroupRequest.ReadOnly =
    zio.aws.resourcegroups.model.CreateGroupRequest.wrap(buildAwsValue())
}
object CreateGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.CreateGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.CreateGroupRequest =
      zio.aws.resourcegroups.model.CreateGroupRequest(
        name,
        description.map(value => value),
        resourceQuery.map(value => value.asEditable),
        tags.map(value => value),
        configuration.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: GroupName
    def description: Optional[Description]
    def resourceQuery
        : Optional[zio.aws.resourcegroups.model.ResourceQuery.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def configuration: Optional[
      List[zio.aws.resourcegroups.model.GroupConfigurationItem.ReadOnly]
    ]
    def getName: ZIO[Any, Nothing, GroupName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getResourceQuery: ZIO[
      Any,
      AwsError,
      zio.aws.resourcegroups.model.ResourceQuery.ReadOnly
    ] = AwsError.unwrapOptionField("resourceQuery", resourceQuery)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getConfiguration: ZIO[Any, AwsError, List[
      zio.aws.resourcegroups.model.GroupConfigurationItem.ReadOnly
    ]] = AwsError.unwrapOptionField("configuration", configuration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.CreateGroupRequest
  ) extends zio.aws.resourcegroups.model.CreateGroupRequest.ReadOnly {
    override val name: GroupName =
      zio.aws.resourcegroups.model.primitives.GroupName(impl.name())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.resourcegroups.model.primitives.Description(value))
    override val resourceQuery
        : Optional[zio.aws.resourcegroups.model.ResourceQuery.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceQuery())
        .map(value => zio.aws.resourcegroups.model.ResourceQuery.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.resourcegroups.model.primitives.TagKey(
              key
            ) -> zio.aws.resourcegroups.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val configuration: Optional[
      List[zio.aws.resourcegroups.model.GroupConfigurationItem.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.configuration())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.resourcegroups.model.GroupConfigurationItem.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.CreateGroupRequest
  ): zio.aws.resourcegroups.model.CreateGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
