package zio.aws.resourcegroups
import zio.prelude.Subtype
import zio.aws.resourcegroups.model.primitives.{
  GroupConfigurationParameterValue,
  TagValue,
  ResourceFilterValue,
  ResourceArn,
  TagKey,
  GroupFilterValue
}
import zio.aws.resourcegroups.model.primitives.TagKey.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object Description extends Subtype[String]
    type Description = zio.aws.resourcegroups.model.primitives.Description.Type
    object ErrorCode extends Subtype[String]
    type ErrorCode = zio.aws.resourcegroups.model.primitives.ErrorCode.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage =
      zio.aws.resourcegroups.model.primitives.ErrorMessage.Type
    object GroupArn extends Subtype[String]
    type GroupArn = zio.aws.resourcegroups.model.primitives.GroupArn.Type
    object GroupConfigurationFailureReason extends Subtype[String]
    type GroupConfigurationFailureReason =
      zio.aws.resourcegroups.model.primitives.GroupConfigurationFailureReason.Type
    object GroupConfigurationParameterName extends Subtype[String]
    type GroupConfigurationParameterName =
      zio.aws.resourcegroups.model.primitives.GroupConfigurationParameterName.Type
    object GroupConfigurationParameterValue extends Subtype[String]
    type GroupConfigurationParameterValue =
      zio.aws.resourcegroups.model.primitives.GroupConfigurationParameterValue.Type
    object GroupConfigurationType extends Subtype[String]
    type GroupConfigurationType =
      zio.aws.resourcegroups.model.primitives.GroupConfigurationType.Type
    object GroupFilterValue extends Subtype[String]
    type GroupFilterValue =
      zio.aws.resourcegroups.model.primitives.GroupFilterValue.Type
    object GroupLifecycleEventsStatusMessage extends Subtype[String]
    type GroupLifecycleEventsStatusMessage =
      zio.aws.resourcegroups.model.primitives.GroupLifecycleEventsStatusMessage.Type
    object GroupName extends Subtype[String]
    type GroupName = zio.aws.resourcegroups.model.primitives.GroupName.Type
    object GroupString extends Subtype[String]
    type GroupString = zio.aws.resourcegroups.model.primitives.GroupString.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.resourcegroups.model.primitives.MaxResults.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.resourcegroups.model.primitives.NextToken.Type
    object Query extends Subtype[String]
    type Query = zio.aws.resourcegroups.model.primitives.Query.Type
    object QueryErrorMessage extends Subtype[String]
    type QueryErrorMessage =
      zio.aws.resourcegroups.model.primitives.QueryErrorMessage.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.resourcegroups.model.primitives.ResourceArn.Type
    object ResourceFilterValue extends Subtype[String]
    type ResourceFilterValue =
      zio.aws.resourcegroups.model.primitives.ResourceFilterValue.Type
    object ResourceType extends Subtype[String]
    type ResourceType =
      zio.aws.resourcegroups.model.primitives.ResourceType.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.resourcegroups.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.resourcegroups.model.primitives.TagValue.Type
  }
  type FailedResourceList = List[zio.aws.resourcegroups.model.FailedResource]
  type GroupConfigurationList =
    List[zio.aws.resourcegroups.model.GroupConfigurationItem]
  type GroupConfigurationParameterValueList =
    List[GroupConfigurationParameterValue]
  type GroupFilterList = List[zio.aws.resourcegroups.model.GroupFilter]
  type GroupFilterValues = List[GroupFilterValue]
  type GroupIdentifierList = List[zio.aws.resourcegroups.model.GroupIdentifier]
  type GroupList = List[zio.aws.resourcegroups.model.Group]
  type GroupParameterList =
    List[zio.aws.resourcegroups.model.GroupConfigurationParameter]
  type ListGroupResourcesItemList =
    List[zio.aws.resourcegroups.model.ListGroupResourcesItem]
  type PendingResourceList = List[zio.aws.resourcegroups.model.PendingResource]
  type QueryErrorList = List[zio.aws.resourcegroups.model.QueryError]
  type ResourceArnList = List[ResourceArn]
  type ResourceFilterList = List[zio.aws.resourcegroups.model.ResourceFilter]
  type ResourceFilterValues = List[ResourceFilterValue]
  type ResourceIdentifierList =
    List[zio.aws.resourcegroups.model.ResourceIdentifier]
  type TagKeyList = List[TagKey]
  type Tags = Map[TagKey, TagValue]
}
