package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateAccountSettingsRequest(
    groupLifecycleEventsDesiredStatus: Optional[
      zio.aws.resourcegroups.model.GroupLifecycleEventsDesiredStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.UpdateAccountSettingsRequest = {
    import UpdateAccountSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.UpdateAccountSettingsRequest
      .builder()
      .optionallyWith(
        groupLifecycleEventsDesiredStatus.map(value => value.unwrap)
      )(_.groupLifecycleEventsDesiredStatus)
      .build()
  }
  def asReadOnly
      : zio.aws.resourcegroups.model.UpdateAccountSettingsRequest.ReadOnly =
    zio.aws.resourcegroups.model.UpdateAccountSettingsRequest
      .wrap(buildAwsValue())
}
object UpdateAccountSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.UpdateAccountSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.UpdateAccountSettingsRequest =
      zio.aws.resourcegroups.model.UpdateAccountSettingsRequest(
        groupLifecycleEventsDesiredStatus.map(value => value)
      )
    def groupLifecycleEventsDesiredStatus: Optional[
      zio.aws.resourcegroups.model.GroupLifecycleEventsDesiredStatus
    ]
    def getGroupLifecycleEventsDesiredStatus: ZIO[
      Any,
      AwsError,
      zio.aws.resourcegroups.model.GroupLifecycleEventsDesiredStatus
    ] = AwsError.unwrapOptionField(
      "groupLifecycleEventsDesiredStatus",
      groupLifecycleEventsDesiredStatus
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.UpdateAccountSettingsRequest
  ) extends zio.aws.resourcegroups.model.UpdateAccountSettingsRequest.ReadOnly {
    override val groupLifecycleEventsDesiredStatus: Optional[
      zio.aws.resourcegroups.model.GroupLifecycleEventsDesiredStatus
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.groupLifecycleEventsDesiredStatus())
      .map(value =>
        zio.aws.resourcegroups.model.GroupLifecycleEventsDesiredStatus
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.UpdateAccountSettingsRequest
  ): zio.aws.resourcegroups.model.UpdateAccountSettingsRequest.ReadOnly =
    new Wrapper(impl)
}
