package zio.aws.resourcegroups.model
import scala.jdk.CollectionConverters._
sealed trait QueryErrorCode {
  def unwrap
      : software.amazon.awssdk.services.resourcegroups.model.QueryErrorCode
}
object QueryErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.resourcegroups.model.QueryErrorCode
  ): zio.aws.resourcegroups.model.QueryErrorCode = value match {
    case software.amazon.awssdk.services.resourcegroups.model.QueryErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.resourcegroups.model.QueryErrorCode.CLOUDFORMATION_STACK_INACTIVE =>
      val r = CLOUDFORMATION_STACK_INACTIVE
      r
    case software.amazon.awssdk.services.resourcegroups.model.QueryErrorCode.CLOUDFORMATION_STACK_NOT_EXISTING =>
      val r = CLOUDFORMATION_STACK_NOT_EXISTING
      r
    case software.amazon.awssdk.services.resourcegroups.model.QueryErrorCode.CLOUDFORMATION_STACK_UNASSUMABLE_ROLE =>
      val r = CLOUDFORMATION_STACK_UNASSUMABLE_ROLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.resourcegroups.model.QueryErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.resourcegroups.model.QueryErrorCode =
      software.amazon.awssdk.services.resourcegroups.model.QueryErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object CLOUDFORMATION_STACK_INACTIVE
      extends zio.aws.resourcegroups.model.QueryErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.resourcegroups.model.QueryErrorCode =
      software.amazon.awssdk.services.resourcegroups.model.QueryErrorCode.CLOUDFORMATION_STACK_INACTIVE
  }
  case object CLOUDFORMATION_STACK_NOT_EXISTING
      extends zio.aws.resourcegroups.model.QueryErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.resourcegroups.model.QueryErrorCode =
      software.amazon.awssdk.services.resourcegroups.model.QueryErrorCode.CLOUDFORMATION_STACK_NOT_EXISTING
  }
  case object CLOUDFORMATION_STACK_UNASSUMABLE_ROLE
      extends zio.aws.resourcegroups.model.QueryErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.resourcegroups.model.QueryErrorCode =
      software.amazon.awssdk.services.resourcegroups.model.QueryErrorCode.CLOUDFORMATION_STACK_UNASSUMABLE_ROLE
  }
}
