package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.resourcegroups.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListGroupsResponse(
    groupIdentifiers: Optional[
      Iterable[zio.aws.resourcegroups.model.GroupIdentifier]
    ] = Optional.Absent,
    groups: Optional[Iterable[zio.aws.resourcegroups.model.Group]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.ListGroupsResponse = {
    import ListGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.ListGroupsResponse
      .builder()
      .optionallyWith(
        groupIdentifiers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groupIdentifiers)
      .optionallyWith(
        groups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groups)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.ListGroupsResponse.ReadOnly =
    zio.aws.resourcegroups.model.ListGroupsResponse.wrap(buildAwsValue())
}
object ListGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.ListGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.ListGroupsResponse =
      zio.aws.resourcegroups.model.ListGroupsResponse(
        groupIdentifiers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        groups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def groupIdentifiers
        : Optional[List[zio.aws.resourcegroups.model.GroupIdentifier.ReadOnly]]
    def groups: Optional[List[zio.aws.resourcegroups.model.Group.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getGroupIdentifiers: ZIO[Any, AwsError, List[
      zio.aws.resourcegroups.model.GroupIdentifier.ReadOnly
    ]] = AwsError.unwrapOptionField("groupIdentifiers", groupIdentifiers)
    def getGroups: ZIO[Any, AwsError, List[
      zio.aws.resourcegroups.model.Group.ReadOnly
    ]] = AwsError.unwrapOptionField("groups", groups)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.ListGroupsResponse
  ) extends zio.aws.resourcegroups.model.ListGroupsResponse.ReadOnly {
    override val groupIdentifiers: Optional[
      List[zio.aws.resourcegroups.model.GroupIdentifier.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.groupIdentifiers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.resourcegroups.model.GroupIdentifier.wrap(item)
        }.toList
      )
    override val groups
        : Optional[List[zio.aws.resourcegroups.model.Group.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.resourcegroups.model.Group.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.resourcegroups.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.ListGroupsResponse
  ): zio.aws.resourcegroups.model.ListGroupsResponse.ReadOnly = new Wrapper(
    impl
  )
}
