package zio.aws.resourcegroups.model
import scala.jdk.CollectionConverters._
sealed trait ResourceFilterName {
  def unwrap
      : software.amazon.awssdk.services.resourcegroups.model.ResourceFilterName
}
object ResourceFilterName {
  def wrap(
      value: software.amazon.awssdk.services.resourcegroups.model.ResourceFilterName
  ): zio.aws.resourcegroups.model.ResourceFilterName = value match {
    case software.amazon.awssdk.services.resourcegroups.model.ResourceFilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.resourcegroups.model.ResourceFilterName.RESOURCE_TYPE =>
      val r = `resource-type`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.resourcegroups.model.ResourceFilterName {
    override def unwrap
        : software.amazon.awssdk.services.resourcegroups.model.ResourceFilterName =
      software.amazon.awssdk.services.resourcegroups.model.ResourceFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object `resource-type`
      extends zio.aws.resourcegroups.model.ResourceFilterName {
    override def unwrap
        : software.amazon.awssdk.services.resourcegroups.model.ResourceFilterName =
      software.amazon.awssdk.services.resourcegroups.model.ResourceFilterName.RESOURCE_TYPE
  }
}
