package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.resourcegroups.model.primitives.GroupArn
import scala.jdk.CollectionConverters._
final case class GetTagsRequest(arn: GroupArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.GetTagsRequest = {
    import GetTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.GetTagsRequest
      .builder()
      .arn(GroupArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.GetTagsRequest.ReadOnly =
    zio.aws.resourcegroups.model.GetTagsRequest.wrap(buildAwsValue())
}
object GetTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.GetTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.GetTagsRequest =
      zio.aws.resourcegroups.model.GetTagsRequest(arn)
    def arn: GroupArn
    def getArn: ZIO[Any, Nothing, GroupArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.GetTagsRequest
  ) extends zio.aws.resourcegroups.model.GetTagsRequest.ReadOnly {
    override val arn: GroupArn =
      zio.aws.resourcegroups.model.primitives.GroupArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.GetTagsRequest
  ): zio.aws.resourcegroups.model.GetTagsRequest.ReadOnly = new Wrapper(impl)
}
