package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetGroupResponse(
    group: Optional[zio.aws.resourcegroups.model.Group] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.GetGroupResponse = {
    import GetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.GetGroupResponse
      .builder()
      .optionallyWith(group.map(value => value.buildAwsValue()))(_.group)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.GetGroupResponse.ReadOnly =
    zio.aws.resourcegroups.model.GetGroupResponse.wrap(buildAwsValue())
}
object GetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.GetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.GetGroupResponse =
      zio.aws.resourcegroups.model
        .GetGroupResponse(group.map(value => value.asEditable))
    def group: Optional[zio.aws.resourcegroups.model.Group.ReadOnly]
    def getGroup
        : ZIO[Any, AwsError, zio.aws.resourcegroups.model.Group.ReadOnly] =
      AwsError.unwrapOptionField("group", group)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.GetGroupResponse
  ) extends zio.aws.resourcegroups.model.GetGroupResponse.ReadOnly {
    override val group: Optional[zio.aws.resourcegroups.model.Group.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.group())
        .map(value => zio.aws.resourcegroups.model.Group.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.GetGroupResponse
  ): zio.aws.resourcegroups.model.GetGroupResponse.ReadOnly = new Wrapper(impl)
}
