package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.resourcegroups.model.primitives.ResourceFilterValue
import scala.jdk.CollectionConverters._
final case class ResourceFilter(
    name: zio.aws.resourcegroups.model.ResourceFilterName,
    values: Iterable[ResourceFilterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.ResourceFilter = {
    import ResourceFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.ResourceFilter
      .builder()
      .name(name.unwrap)
      .values(values.map { item =>
        ResourceFilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.ResourceFilter.ReadOnly =
    zio.aws.resourcegroups.model.ResourceFilter.wrap(buildAwsValue())
}
object ResourceFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.ResourceFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.ResourceFilter =
      zio.aws.resourcegroups.model.ResourceFilter(name, values)
    def name: zio.aws.resourcegroups.model.ResourceFilterName
    def values: List[ResourceFilterValue]
    def getName
        : ZIO[Any, Nothing, zio.aws.resourcegroups.model.ResourceFilterName] =
      ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[ResourceFilterValue]] =
      ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.ResourceFilter
  ) extends zio.aws.resourcegroups.model.ResourceFilter.ReadOnly {
    override val name: zio.aws.resourcegroups.model.ResourceFilterName =
      zio.aws.resourcegroups.model.ResourceFilterName.wrap(impl.name())
    override val values: List[ResourceFilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.resourcegroups.model.primitives.ResourceFilterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.ResourceFilter
  ): zio.aws.resourcegroups.model.ResourceFilter.ReadOnly = new Wrapper(impl)
}
