package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.resourcegroups.model.primitives.{TagValue, TagKey, GroupArn}
import scala.jdk.CollectionConverters._
final case class GetTagsResponse(
    arn: Optional[GroupArn] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.GetTagsResponse = {
    import GetTagsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.GetTagsResponse
      .builder()
      .optionallyWith(
        arn.map(value => GroupArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.GetTagsResponse.ReadOnly =
    zio.aws.resourcegroups.model.GetTagsResponse.wrap(buildAwsValue())
}
object GetTagsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.GetTagsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.GetTagsResponse =
      zio.aws.resourcegroups.model
        .GetTagsResponse(arn.map(value => value), tags.map(value => value))
    def arn: Optional[GroupArn]
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, GroupArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.GetTagsResponse
  ) extends zio.aws.resourcegroups.model.GetTagsResponse.ReadOnly {
    override val arn: Optional[GroupArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.resourcegroups.model.primitives.GroupArn(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.resourcegroups.model.primitives.TagKey(
              key
            ) -> zio.aws.resourcegroups.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.GetTagsResponse
  ): zio.aws.resourcegroups.model.GetTagsResponse.ReadOnly = new Wrapper(impl)
}
