package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.resourcegroups.model.primitives.{ResourceType, ResourceArn}
import scala.jdk.CollectionConverters._
final case class ResourceIdentifier(
    resourceArn: Optional[ResourceArn] = Optional.Absent,
    resourceType: Optional[ResourceType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.ResourceIdentifier = {
    import ResourceIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.ResourceIdentifier
      .builder()
      .optionallyWith(
        resourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        resourceType.map(value => ResourceType.unwrap(value): java.lang.String)
      )(_.resourceType)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.ResourceIdentifier.ReadOnly =
    zio.aws.resourcegroups.model.ResourceIdentifier.wrap(buildAwsValue())
}
object ResourceIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.ResourceIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.ResourceIdentifier =
      zio.aws.resourcegroups.model.ResourceIdentifier(
        resourceArn.map(value => value),
        resourceType.map(value => value)
      )
    def resourceArn: Optional[ResourceArn]
    def resourceType: Optional[ResourceType]
    def getResourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getResourceType: ZIO[Any, AwsError, ResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.ResourceIdentifier
  ) extends zio.aws.resourcegroups.model.ResourceIdentifier.ReadOnly {
    override val resourceArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.resourcegroups.model.primitives.ResourceArn(value))
    override val resourceType: Optional[ResourceType] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceType())
      .map(value => zio.aws.resourcegroups.model.primitives.ResourceType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.ResourceIdentifier
  ): zio.aws.resourcegroups.model.ResourceIdentifier.ReadOnly = new Wrapper(
    impl
  )
}
