package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.resourcegroups.model.primitives.GroupFilterValue
import scala.jdk.CollectionConverters._
final case class GroupFilter(
    name: zio.aws.resourcegroups.model.GroupFilterName,
    values: Iterable[GroupFilterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.GroupFilter = {
    import GroupFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.GroupFilter
      .builder()
      .name(name.unwrap)
      .values(values.map { item =>
        GroupFilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.GroupFilter.ReadOnly =
    zio.aws.resourcegroups.model.GroupFilter.wrap(buildAwsValue())
}
object GroupFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.GroupFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.GroupFilter =
      zio.aws.resourcegroups.model.GroupFilter(name, values)
    def name: zio.aws.resourcegroups.model.GroupFilterName
    def values: List[GroupFilterValue]
    def getName
        : ZIO[Any, Nothing, zio.aws.resourcegroups.model.GroupFilterName] =
      ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[GroupFilterValue]] =
      ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.GroupFilter
  ) extends zio.aws.resourcegroups.model.GroupFilter.ReadOnly {
    override val name: zio.aws.resourcegroups.model.GroupFilterName =
      zio.aws.resourcegroups.model.GroupFilterName.wrap(impl.name())
    override val values: List[GroupFilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.resourcegroups.model.primitives.GroupFilterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.GroupFilter
  ): zio.aws.resourcegroups.model.GroupFilter.ReadOnly = new Wrapper(impl)
}
