package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.resourcegroups.model.primitives.{
  ErrorCode,
  ErrorMessage,
  ResourceArn
}
import scala.jdk.CollectionConverters._
final case class FailedResource(
    resourceArn: Optional[ResourceArn] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent,
    errorCode: Optional[ErrorCode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.FailedResource = {
    import FailedResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.FailedResource
      .builder()
      .optionallyWith(
        resourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(
        errorCode.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.errorCode)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.FailedResource.ReadOnly =
    zio.aws.resourcegroups.model.FailedResource.wrap(buildAwsValue())
}
object FailedResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.FailedResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.FailedResource =
      zio.aws.resourcegroups.model.FailedResource(
        resourceArn.map(value => value),
        errorMessage.map(value => value),
        errorCode.map(value => value)
      )
    def resourceArn: Optional[ResourceArn]
    def errorMessage: Optional[ErrorMessage]
    def errorCode: Optional[ErrorCode]
    def getResourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getErrorCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.FailedResource
  ) extends zio.aws.resourcegroups.model.FailedResource.ReadOnly {
    override val resourceArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.resourcegroups.model.primitives.ResourceArn(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.resourcegroups.model.primitives.ErrorMessage(value))
    override val errorCode: Optional[ErrorCode] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => zio.aws.resourcegroups.model.primitives.ErrorCode(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.FailedResource
  ): zio.aws.resourcegroups.model.FailedResource.ReadOnly = new Wrapper(impl)
}
