package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.resourcegroups.model.primitives.{GroupString, GroupName}
import scala.jdk.CollectionConverters._
final case class DeleteGroupRequest(
    groupName: Optional[GroupName] = Optional.Absent,
    group: Optional[GroupString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.DeleteGroupRequest = {
    import DeleteGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.DeleteGroupRequest
      .builder()
      .optionallyWith(
        groupName.map(value => GroupName.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        group.map(value => GroupString.unwrap(value): java.lang.String)
      )(_.group)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.DeleteGroupRequest.ReadOnly =
    zio.aws.resourcegroups.model.DeleteGroupRequest.wrap(buildAwsValue())
}
object DeleteGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.DeleteGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.DeleteGroupRequest =
      zio.aws.resourcegroups.model.DeleteGroupRequest(
        groupName.map(value => value),
        group.map(value => value)
      )
    def groupName: Optional[GroupName]
    def group: Optional[GroupString]
    def getGroupName: ZIO[Any, AwsError, GroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroup: ZIO[Any, AwsError, GroupString] =
      AwsError.unwrapOptionField("group", group)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.DeleteGroupRequest
  ) extends zio.aws.resourcegroups.model.DeleteGroupRequest.ReadOnly {
    override val groupName: Optional[GroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.groupName())
      .map(value => zio.aws.resourcegroups.model.primitives.GroupName(value))
    override val group: Optional[GroupString] = zio.aws.core.internal
      .optionalFromNullable(impl.group())
      .map(value => zio.aws.resourcegroups.model.primitives.GroupString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.DeleteGroupRequest
  ): zio.aws.resourcegroups.model.DeleteGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
