package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.resourcegroups.model.primitives.{ResourceArn, GroupString}
import scala.jdk.CollectionConverters._
final case class GroupResourcesRequest(
    group: GroupString,
    resourceArns: Iterable[ResourceArn]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.GroupResourcesRequest = {
    import GroupResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.GroupResourcesRequest
      .builder()
      .group(GroupString.unwrap(group): java.lang.String)
      .resourceArns(resourceArns.map { item =>
        ResourceArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.GroupResourcesRequest.ReadOnly =
    zio.aws.resourcegroups.model.GroupResourcesRequest.wrap(buildAwsValue())
}
object GroupResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.GroupResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.GroupResourcesRequest =
      zio.aws.resourcegroups.model.GroupResourcesRequest(group, resourceArns)
    def group: GroupString
    def resourceArns: List[ResourceArn]
    def getGroup: ZIO[Any, Nothing, GroupString] = ZIO.succeed(group)
    def getResourceArns: ZIO[Any, Nothing, List[ResourceArn]] =
      ZIO.succeed(resourceArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.GroupResourcesRequest
  ) extends zio.aws.resourcegroups.model.GroupResourcesRequest.ReadOnly {
    override val group: GroupString =
      zio.aws.resourcegroups.model.primitives.GroupString(impl.group())
    override val resourceArns: List[ResourceArn] = impl
      .resourceArns()
      .asScala
      .map { item =>
        zio.aws.resourcegroups.model.primitives.ResourceArn(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.GroupResourcesRequest
  ): zio.aws.resourcegroups.model.GroupResourcesRequest.ReadOnly = new Wrapper(
    impl
  )
}
