package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.resourcegroups.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListGroupResourcesResponse(
    resources: Option[
      Iterable[zio.aws.resourcegroups.model.ListGroupResourcesItem]
    ] = None,
    resourceIdentifiers: Option[
      Iterable[zio.aws.resourcegroups.model.ResourceIdentifier]
    ] = None,
    nextToken: Option[NextToken] = None,
    queryErrors: Option[Iterable[zio.aws.resourcegroups.model.QueryError]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesResponse = {
    import ListGroupResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesResponse
      .builder()
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resources)
      .optionallyWith(
        resourceIdentifiers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceIdentifiers)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        queryErrors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.queryErrors)
      .build()
  }
  def asReadOnly
      : zio.aws.resourcegroups.model.ListGroupResourcesResponse.ReadOnly =
    zio.aws.resourcegroups.model.ListGroupResourcesResponse
      .wrap(buildAwsValue())
}
object ListGroupResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.ListGroupResourcesResponse =
      zio.aws.resourcegroups.model.ListGroupResourcesResponse(
        resources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceIdentifiers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        queryErrors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def resources: Option[
      List[zio.aws.resourcegroups.model.ListGroupResourcesItem.ReadOnly]
    ]
    def resourceIdentifiers
        : Option[List[zio.aws.resourcegroups.model.ResourceIdentifier.ReadOnly]]
    def nextToken: Option[NextToken]
    def queryErrors
        : Option[List[zio.aws.resourcegroups.model.QueryError.ReadOnly]]
    def getResources: ZIO[Any, AwsError, List[
      zio.aws.resourcegroups.model.ListGroupResourcesItem.ReadOnly
    ]] = AwsError.unwrapOptionField("resources", resources)
    def getResourceIdentifiers: ZIO[Any, AwsError, List[
      zio.aws.resourcegroups.model.ResourceIdentifier.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceIdentifiers", resourceIdentifiers)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getQueryErrors: ZIO[Any, AwsError, List[
      zio.aws.resourcegroups.model.QueryError.ReadOnly
    ]] = AwsError.unwrapOptionField("queryErrors", queryErrors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesResponse
  ) extends zio.aws.resourcegroups.model.ListGroupResourcesResponse.ReadOnly {
    override val resources: Option[
      List[zio.aws.resourcegroups.model.ListGroupResourcesItem.ReadOnly]
    ] = scala
      .Option(impl.resources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.resourcegroups.model.ListGroupResourcesItem.wrap(item)
        }.toList
      )
    override val resourceIdentifiers: Option[
      List[zio.aws.resourcegroups.model.ResourceIdentifier.ReadOnly]
    ] = scala
      .Option(impl.resourceIdentifiers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.resourcegroups.model.ResourceIdentifier.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.resourcegroups.model.primitives.NextToken(value))
    override val queryErrors
        : Option[List[zio.aws.resourcegroups.model.QueryError.ReadOnly]] = scala
      .Option(impl.queryErrors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.resourcegroups.model.QueryError.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.ListGroupResourcesResponse
  ): zio.aws.resourcegroups.model.ListGroupResourcesResponse.ReadOnly =
    new Wrapper(impl)
}
