package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.resourcegroups.model.primitives.{GroupString, GroupName}
import scala.jdk.CollectionConverters._
final case class GetGroupRequest(
    groupName: Option[GroupName] = None,
    group: Option[GroupString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.GetGroupRequest = {
    import GetGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.GetGroupRequest
      .builder()
      .optionallyWith(
        groupName.map(value => GroupName.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        group.map(value => GroupString.unwrap(value): java.lang.String)
      )(_.group)
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.GetGroupRequest.ReadOnly =
    zio.aws.resourcegroups.model.GetGroupRequest.wrap(buildAwsValue())
}
object GetGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.GetGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.GetGroupRequest =
      zio.aws.resourcegroups.model.GetGroupRequest(
        groupName.map(value => value),
        group.map(value => value)
      )
    def groupName: Option[GroupName]
    def group: Option[GroupString]
    def getGroupName: ZIO[Any, AwsError, GroupName] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getGroup: ZIO[Any, AwsError, GroupString] =
      AwsError.unwrapOptionField("group", group)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.GetGroupRequest
  ) extends zio.aws.resourcegroups.model.GetGroupRequest.ReadOnly {
    override val groupName: Option[GroupName] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.resourcegroups.model.primitives.GroupName(value))
    override val group: Option[GroupString] = scala
      .Option(impl.group())
      .map(value => zio.aws.resourcegroups.model.primitives.GroupString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.GetGroupRequest
  ): zio.aws.resourcegroups.model.GetGroupRequest.ReadOnly = new Wrapper(impl)
}
