package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetGroupConfigurationResponse(
    groupConfiguration: Option[
      zio.aws.resourcegroups.model.GroupConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.GetGroupConfigurationResponse = {
    import GetGroupConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.GetGroupConfigurationResponse
      .builder()
      .optionallyWith(groupConfiguration.map(value => value.buildAwsValue()))(
        _.groupConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.resourcegroups.model.GetGroupConfigurationResponse.ReadOnly =
    zio.aws.resourcegroups.model.GetGroupConfigurationResponse
      .wrap(buildAwsValue())
}
object GetGroupConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.GetGroupConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.GetGroupConfigurationResponse =
      zio.aws.resourcegroups.model.GetGroupConfigurationResponse(
        groupConfiguration.map(value => value.asEditable)
      )
    def groupConfiguration
        : Option[zio.aws.resourcegroups.model.GroupConfiguration.ReadOnly]
    def getGroupConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.resourcegroups.model.GroupConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("groupConfiguration", groupConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.GetGroupConfigurationResponse
  ) extends zio.aws.resourcegroups.model.GetGroupConfigurationResponse.ReadOnly {
    override val groupConfiguration
        : Option[zio.aws.resourcegroups.model.GroupConfiguration.ReadOnly] =
      scala
        .Option(impl.groupConfiguration())
        .map(value =>
          zio.aws.resourcegroups.model.GroupConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.GetGroupConfigurationResponse
  ): zio.aws.resourcegroups.model.GetGroupConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
