package zio.aws.resourcegroups.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.resourcegroups.model.primitives.{TagValue, TagKey, GroupArn}
import scala.jdk.CollectionConverters._
final case class TagRequest(arn: GroupArn, tags: Map[TagKey, TagValue]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.resourcegroups.model.TagRequest = {
    import TagRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.resourcegroups.model.TagRequest
      .builder()
      .arn(GroupArn.unwrap(arn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.resourcegroups.model.TagRequest.ReadOnly =
    zio.aws.resourcegroups.model.TagRequest.wrap(buildAwsValue())
}
object TagRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.resourcegroups.model.TagRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.resourcegroups.model.TagRequest =
      zio.aws.resourcegroups.model.TagRequest(arn, tags)
    def arn: GroupArn
    def tags: Map[TagKey, TagValue]
    def getArn: ZIO[Any, Nothing, GroupArn] = ZIO.succeed(arn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.resourcegroups.model.TagRequest
  ) extends zio.aws.resourcegroups.model.TagRequest.ReadOnly {
    override val arn: GroupArn =
      zio.aws.resourcegroups.model.primitives.GroupArn(impl.arn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.resourcegroups.model.primitives.TagKey(
          key
        ) -> zio.aws.resourcegroups.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.resourcegroups.model.TagRequest
  ): zio.aws.resourcegroups.model.TagRequest.ReadOnly = new Wrapper(impl)
}
